﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.ComponentModel;
using System.Data;
using AZVIC.Ei8htPOS.Utilities;

namespace AZVIC.Ei8htPOS.Entities
{
    public class ContactUs : BusinessBaseClass
    {

        public ContactUs()
        {

        }

        public ContactUs(IDataReader myDataRecord)
        {
            UniqueID = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("ContactUsID")) ? Guid.Empty : myDataRecord.GetGuid(myDataRecord.GetOrdinal("ContactUsID"));
            Name = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("Name")) ? string.Empty : myDataRecord.GetString(myDataRecord.GetOrdinal("Name"));
            CAddress = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("CAddress")) ? string.Empty : myDataRecord.GetString(myDataRecord.GetOrdinal("CAddress"));
            CompanyName = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("CompanyName")) ? string.Empty : myDataRecord.GetString(myDataRecord.GetOrdinal("CompanyName"));
            City = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("City")) ? string.Empty : myDataRecord.GetString(myDataRecord.GetOrdinal("City"));
            PhoneNo = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("PhoneNo")) ? string.Empty : myDataRecord.GetString(myDataRecord.GetOrdinal("PhoneNo"));
            Country = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("Country")) ? string.Empty : myDataRecord.GetString(myDataRecord.GetOrdinal("Country"));
            Email = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("Email")) ? string.Empty : myDataRecord.GetString(myDataRecord.GetOrdinal("Email"));
            CSubject = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("CSubject")) ? string.Empty : myDataRecord.GetString(myDataRecord.GetOrdinal("CSubject"));
            CMessage = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("CMessage")) ? string.Empty : myDataRecord.GetString(myDataRecord.GetOrdinal("CMessage"));
            CreatedDate = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("CreatedDate")) ? DateTime.MinValue : myDataRecord.GetDateTime(myDataRecord.GetOrdinal("CreatedDate"));
            ModifiedDate = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("ModifiedDate")) ? DateTime.MinValue : myDataRecord.GetDateTime(myDataRecord.GetOrdinal("ModifiedDate"));
            IsActive = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("IsActive")) ? false : myDataRecord.GetBoolean(myDataRecord.GetOrdinal("IsActive"));
            //IsDeleted = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("IsDeleted")) ? false : myDataRecord.GetBoolean(myDataRecord.GetOrdinal("IsDeleted"));
        }

        [DataObjectField(true, false, false)]
        public override Guid UniqueID { get; set; }

        public string Name { get; set; }

        public string CAddress { get; set; }

        public string CompanyName { get; set; }

        public string City { get; set; }

        public string PhoneNo { get; set; }

        public string Country { get; set; }

        public string Email { get; set; }

        public string CSubject { get; set; }

        public string CMessage { get; set; }

        public override DateTime CreatedDate { get; set; }

        public override DateTime ModifiedDate { get; set; }

        public override GlobalConfigurations.Mode Mode { get; set; }

        public override bool IsActive { get; set; }
    }
}
